%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
% mfile to solve of "Integrated design with UIO"
% Jianglin Lan, 2015-0903, function file
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function sys_state = Norminal_sys_performance(t,xx,A,B,D,C,Delta_A,Kx,M,G,L,H)
hat_eta = xx(1);
xi1 = xx(2);
xi2 = xx(3);
xi3 = xx(4);
x1 = xx(5);
x2 = xx(6);

global Intn_ts Intn_count Intn_tmp Intn_yy1 Intn_yy2 Intn_u0 Intn_ffa Intn_u


%%%%%%%%%%%%%%%%%
Y = 0.05*ones(1,2);
omega =  0.5213;
N = pinv(C*B) - Y * (eye(2) - C*B*pinv(C*B));
psi = 0.001;  
phi = omega*psi + 0.01;
varep1 = 0.001; varep2 = 1.0e-3; sigma = 1;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% disturbance and fault
d = 0.01 * sin(t);
fm = -Theta(t)*Intn_u0;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
x = [x1;x2];
y = C*x;
xi = [xi1;xi2;xi3];
hat_x = xi + H*y;

% sliding surface
yc = y;
s_t = N*yc;

% controller
u_l = - [Kx 0]*hat_x;
rho2 = hat_eta + varep1 + phi;

u_n = -rho2 * (s_t / (norm(s_t,2) + varep2));

u = u_l + u_n;
Intn_u0 = u;

dot_hat_eta = sigma * norm(s_t,2);

%observer
dot_xi = M* xi + G*u + L*y;

% sys dynamic
dot_x = (A + Delta_A)*x + B*(1 - Theta(t))*u + D*d;

% data saving 
if mod(Intn_tmp,2)==0
    Intn_count = Intn_count + 1;
Intn_ts(Intn_count) = t;
Intn_ffa(Intn_count) = fm;
Intn_yy1(Intn_count) = yc(1);
Intn_yy2(Intn_count) = yc(2);
Intn_u(Intn_count) = u;
end
Intn_tmp = Intn_tmp + 1;

sys_state = [dot_hat_eta;dot_xi;dot_x];